﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using Dapper;
 
using Seguridad;





namespace Nova.Controllers.POA.Arboles
{
    public class PoaArbolesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Arboles
        public ActionResult Index()
        {
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            if (anioSeleccionado == 0)
            {
                anioSeleccionado = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }

            //string Estructura = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            //int IdeEstructura = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query;

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                query = @"select IdProyectosAño,b.Numero,b.IdProyectos, d.IdProyectoArbol,b.Proyecto,a.AñoProyectos as Año
                        ,(case  when d.DescripcionElementoObjetivos is null then 0 else d.DescripcionElementoObjetivos end) as EsArbolObjetivos
                        , (case  when d.DescripcionElementoProblemas IS NULL  then 0 else d.DescripcionElementoProblemas end) as EsArbolProblemas
                        ,EsCerradoArbolProblemas
						,EsCerradoArbolObjetivos   
                        from Poa_ProyectosAño a
                        inner join Poa_Proyectos b on a.IdProyectos=b.IdProyectos 
                        left join (select IdProyectos,max (IdProyectoArbol)IdProyectoArbol
                        , sum(case  when DescripcionElementoObjetivos is null then 0 else 1 end) as DescripcionElementoObjetivos
                        , sum(case  when DescripcionElementoProblemas IS NULL  then 0 else 1 end) as DescripcionElementoProblemas
                        from Poa_ProyectoArbol  
                        where AñoArbol=  @anioSeleccionado 
                        group by    IdProyectos   ) d on d.idProyectos =  a.IdProyectos
                        where a.AñoProyectos = @anioSeleccionado";
            }
            else
            {
                query = @" select IdProyectosAño,b.Numero,b.IdProyectos, d.IdProyectoArbol,b.Proyecto,a.AñoProyectos as Año
                        ,(case  when d.DescripcionElementoObjetivos is null then 0 else d.DescripcionElementoObjetivos end) as EsArbolObjetivos
                        , (case  when d.DescripcionElementoProblemas IS NULL  then 0 else d.DescripcionElementoProblemas end) as EsArbolProblemas
                        ,EsCerradoArbolProblemas
						,EsCerradoArbolObjetivos   
                        from Poa_ProyectosAño a
                        inner join Poa_Proyectos b on a.IdProyectos=b.IdProyectos 
                        left join (select IdProyectos,max (IdProyectoArbol)IdProyectoArbol
                        , sum(case  when DescripcionElementoObjetivos is null then 0 else 1 end) as DescripcionElementoObjetivos
                        , sum(case  when DescripcionElementoProblemas IS NULL  then 0 else 1 end) as DescripcionElementoProblemas
                        from Poa_ProyectoArbol  
                        where AñoArbol =  @anioSeleccionado 
                        group by    IdProyectos   ) d on d.idProyectos =  a.IdProyectos
                        where a.AñoProyectos = @anioSeleccionado 
                         and IdProyectosAño    in (
                        SELECT 
      IdProyectosAño    
  FROM [bdNova].[dbo].[Poa_ProyectosAñoAreas] a
  inner join Catalogos_ctEstructuraOrganica b on a.IdEstructuraOrganica=b.IdEstructuraOrganica
  where a.IdEstructuraOrganica in (select  IdEstructuraOrganica from Convenios_stConvenioLaboralTrabajadorCategoria where IdConvenioLaboralTrabajadorCategoria=" + Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria + "))";


            }
            //query con estructura organica para identificar el usuario
            //select max(a.IdProyectosAño) IdProyectosAño
            //    , max(b.IdProyectos) IdProyectos
            //    , max(c.IdProyectoArbol)IdProyectoArbol
            //    , b.Proyecto
            //    , a.Año
            //    ,sum(case  when c.DescripcionElementoObjetivos is null then 0 else 1 end) as EsArbolObjetivos
            //    ,sum(case  when c.DescripcionElementoProblemas IS NULL  then 0 else 1 end) as EsArbolProblemas
            //    ,e.IdEstructuraOrganica
            //    from Poa_ProyectosAño a
            //    inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
            //    left join Poa_ProyectoArbol c on c.IdProyectos = b.IdProyectos
            //    left join Poa_ProyectosAñoAreas d on a.IdProyectosAño = d.IdProyectosAño
            //    left join Catalogos_ctEstructuraOrganica e on d.IdEstructuraOrganica = e.IdEstructuraOrganica
            //    where a.Año = (select Año from Poa_SistemaAñoVigente)
            //    group by a.Año,b.Proyecto,e.IdEstructuraOrganica



            var t = (List<Poa_ProyectosAñoArbolesAux>)dp.connection.Query<Poa_ProyectosAñoArbolesAux>(query, new { anioSeleccionado });
            dp.Close();

            //DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });
            dp.Close();
            ViewBag.Anios = new SelectList(listAños, "Value", "Text", anioSeleccionado);
            ViewBag.AnioSelected = anioSeleccionado;
            //var listausuario = t.Where(a => a.IdEstructuraOrganica == IdeEstructura).ToList();
            return View(t.ToList());


            //var poa_ProyectosAño = (db.Poa_ProyectosAño.Include(p => p.Poa_Proyectos).Include(p => p.Poa_PeriodoSexenal)).OrderByDescending(x => x.Año); 
            //return View(poa_ProyectosAño.ToList());
        }

        // GET: Arboles/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosAño poa_ProyectosAño = db.Poa_ProyectosAño.Find(id);
            if (poa_ProyectosAño == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosAño);
        }

        // GET: Arboles/Create
        public ActionResult Create()
        {
            ViewBag.IdProyectos = new SelectList(db.Poa_Proyectos, "IdProyectos", "Objetivo");
            ViewBag.IdPeriodoSexenal = new SelectList(db.Poa_PeriodoSexenal, "IdPeriodoSexenal", "IdPeriodoSexenal");
            return View();
        }

        // POST: Arboles/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProyectosAño,Año,EsCerradoArbolObjetivos,EsCerradoArbolProblemas,IdProyectos,IdPeriodoSexenal")] Poa_ProyectosAño poa_ProyectosAño)
        {
            if (ModelState.IsValid)
            {
                db.Poa_ProyectosAño.Add(poa_ProyectosAño);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdProyectos = new SelectList(db.Poa_Proyectos, "IdProyectos", "Objetivo", poa_ProyectosAño.IdProyectos);
            ViewBag.IdPeriodoSexenal = new SelectList(db.Poa_PeriodoSexenal, "IdPeriodoSexenal", "IdPeriodoSexenal", poa_ProyectosAño.IdPeriodoSexenal);
            return View(poa_ProyectosAño);
        }

        // GET: Arboles/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosAño poa_ProyectosAño = db.Poa_ProyectosAño.Find(id);
            if (poa_ProyectosAño == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdProyectos = new SelectList(db.Poa_Proyectos, "IdProyectos", "Objetivo", poa_ProyectosAño.IdProyectos);
            ViewBag.IdPeriodoSexenal = new SelectList(db.Poa_PeriodoSexenal, "IdPeriodoSexenal", "IdPeriodoSexenal", poa_ProyectosAño.IdPeriodoSexenal);
            return View(poa_ProyectosAño);
        }

        // POST: Arboles/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProyectosAño,AñoProyectos,EsCerradoArbolObjetivos,EsCerradoArbolProblemas,IdProyectos,IdPeriodoSexenal")] Poa_ProyectosAño poa_ProyectosAño)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_ProyectosAño).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdProyectos = new SelectList(db.Poa_Proyectos, "IdProyectos", "Objetivo", poa_ProyectosAño.IdProyectos);
            ViewBag.IdPeriodoSexenal = new SelectList(db.Poa_PeriodoSexenal, "IdPeriodoSexenal", "IdPeriodoSexenal", poa_ProyectosAño.IdPeriodoSexenal);
            return View(poa_ProyectosAño);
        }

        // GET: Arboles/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosAño poa_ProyectosAño = db.Poa_ProyectosAño.Find(id);
            if (poa_ProyectosAño == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosAño);
        }

        // POST: Arboles/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            Poa_ProyectosAño poa_ProyectosAño = db.Poa_ProyectosAño.Find(id);
            db.Poa_ProyectosAño.Remove(poa_ProyectosAño);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
